angular.module('gameFilters', [])
    .filter('convertSeconds', function() {
        return function(numberOfSeconds) {
            var hours, minutes, seconds;
            hours = (numberOfSeconds - numberOfSeconds % 3600) / 3600;
            numberOfSeconds = numberOfSeconds - hours * 3600;
            minutes = (numberOfSeconds - numberOfSeconds % 60) / 60;
            seconds = numberOfSeconds - minutes * 60;

            hours = hours.toString();
            minutes = (minutes < 10) ? '0' + minutes.toString() : minutes.toString();
            seconds = (seconds < 10) ? '0' + seconds.toString() : seconds.toString();

            return hours + ':' + minutes + ':' + seconds;
        };
    })
    .filter('filterStudents', function() {
        return function(students, search) {
            var filtered = [];
            if(search != '')
            {
                var searchArray = search.split(' ');
                angular.forEach(students, function(student) {
                    var str = student.group_name + ' ' + student.username;

                    var found = 0;
                    for(var i = 0; i < searchArray.length; i++)
                    {
                        if(str.toLowerCase().indexOf(searchArray[i].toLowerCase()) != -1)
                        {
                            found++;
                        }
                    }
                    if(found == searchArray.length)
                    {
                        filtered.push(student);
                    }
                });
            }
            else
            {
                filtered = students;
            }
            return filtered;
        };
    })
;